#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative 'request_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/request_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/feedback'


describe '[Story #VAR-1943: New Request - Enter Details]
          [Story #VAR-2399: New Request - Email Preferences]
          [Story #VAR-1945: New Request - Submission/Cancel Entry]
          [Story #VAR-4075: Request - Desired Date - Label Change]
          [Story #VAR-4361: Request Details - REvise to group fields related to communicating with a clerk (HFE recommendation)]
          [Story #VAR-12535: Reintroduce feedback page on request workflow]
          [Story #VAR-12582: Feedback form - update to support requests using Net Promoter Score control]
          [Story # VAR-7833: Submit Request - Save to request db' do
  include OracleUtility
  include DateUtility
  include DriverUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_request = NewAppointmentRequest.new(@driver)
    @detail = RequestAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    @feedback=Feedback.new(@driver)
    TITLE = "Appointments/Requests"

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)

    @today = getDateNthDaysFromNow(0, "%m/%d/%Y")

    @fiveDaysLater = getDateNthDaysFromNow(5, "%m/%d/%Y")
    @nintyDaysLater = getDateNthDaysFromNow(90, "%m/%d/%Y")

    #this will not work in CI but the data will be reset in the jenkins
    @patientID = "1006088937V099668"
    @patientID2 = "1113138327"
    @patientID3 = "1006088937"
    deletePatientData(@patientID)
    deletePatientData(@patientID2)
    deletePatientData(@patientID3)
    @@locationID="523A5"
    @@locationName="BROCKTON VAMC"
    @@friendlyName ="Facility Friendly Text"
    @@new_message_50 = "01234567890123456789012345678901234567890123456789"
    @common.loginEndsOnHome(pw_redacted)
  end

  after(:all) do
    @driver.close
  end

  context 'AC#VAR-2342|TC#VAR-2513: New Appointment - Enter Request Details Criteria
           AC#VAR-2760|TC#VAR-2767: Email preference
           AC#VAR-2480|TC#VAR-2517: New Request - Submission Confirmation Criteria
           AC#VAR-4062|TC#VAR-4063: Revise Best Times to Call options
           AC#VAR-4477|TC#VAR-4478: Request Details - Revise to group fields related to communicating with a clerk
           AC#VAR-10196|TC#10197: Submit Request - Save to request db' do
    it "Verify Request Details section is displayed" do
      #log in as a diff user. if user has more then one DFN, then display a radio button list of all facilities
      #@common.loginEndsOnHome("zztest.patient01", "pass", "D123401")
      @common.selectAddAppointmentButton("VA")
      @new_request.selectNewAppointmentAndSchedule(PRIMARY_CARE, "523", "523A5", "clerk")
      expect(@new_request.request_details_legend).to eq("Request Details")
    end


    it "Multiple Facility: Verify label, informational text and multiple locations" do
      expected_content =[\
                  "* required field",
                  "Step 1: Type of Care",
                  "The VA Appointments app supports scheduling specific types of care. If you do not find the care you need, please contact your facility for assistance.",
                  "* Select the type of care you need:",
                  "Select",
                  "Primary Care",
                  "Audiology",
                  "Express Care",
                  "Optometry",
                  "Outpatient Mental Health",
                  "Step 2: City, State",
                  "* Choose the closest city and state for this appointment:",
                  "Select",
                  "Des Moines, IA",
                  "Iowa City, IA",
                  "BOSTON, MA",
                  "Omaha, NE",
                  "Step 3: Location",
                  "The following facility locations support scheduling Primary Care appointments through this app. If you cannot find the location you need, please visit the VA Facility Locator to contact the facility for assistance.",
                  "* Select the location you want to visit:",
                  "Select",
                  "BOSTON HCS VAMC (BOSTON, MA) - Your Primary Care Team",
                  "BROCKTON VAMC (BROCKTON, MA)",
                  "QUINCY (QUINCY, MA)",
                  "Providers:",
                  "Creamer, Kent",
                  "Your Care Team (PACT)",
                  "Your Care Team (PACT) for BROCKTON VAMC",
                  "Step 4: Scheduling Method",
                  "The location you selected supports the following scheduling methods:",
                  "* Select a scheduling method:",
                  "Schedule Myself",
                  "This method is not available for the type of care you selected.",
                  "Submit a Request to VA Scheduler",
                  "Request Details",
                  "* Purpose of Visit:",
                  "Select",
                  "Routine/Follow-Up",
                  "New Issue",
                  "Medication Concern",
                  "Other",
                  "* Preferred Type of Visit:",
                  "Office Visit",
                  "Phone Call",
                  "Video Conference",
                  "Preferred Appointment Dates/Times",
                   "You may request an appointment date between " + @fiveDaysLater + " and " + @nintyDaysLater + ".",
                   "* Choice #1 Date:",
                   "Choice #1 Time:",
                   "AM", "PM",
                   "Choice #2 Date:",
                   "Choice #2 Time:",
                   "AM", "PM",
                   "Choice #3 Date:",
                   "Choice #3 Time:",
                   "AM", "PM",
                   "Communicating with a Scheduling Clerk About this Request",
                   "Please provide your phone information in case we need to contact you.",
                   "If you would like to talk with VA, you may ask a clerk to call you, or you may message a clerk through this app.",
                   "* Phone:",
                   "* Verify Phone:",
                   "* Best Times for VA to Call:",
                   "Morning",
                   "Afternoon",
                   "Evening",
                   "Would you like the VA to call you regarding this request?",
                   "Yes",
                   "No",
                   "Message a Scheduling Clerk",
                   "(100 char limit)",
                   "100 characters remaining",
                   "Email Preferences",
                   "Send me updates on my appointments and requests:",
                   "Information about updates on my appointments and requests",
                   "Yes",
                   "No",
                   "Submit Request Cancel"
      ]
      actual_content = @new_request.getScreenContent.split("\n")
      expected_content.each_with_index do | expectedScreenRow, i |
        expect(actual_content[i].strip).to eq(expectedScreenRow.strip)
      end

    end

    it "Should verify Purpose of Visit is required" do
      @new_request.clickSubmitRequest
      verifyErrorMessage("Purpose of Visit field is required.")
    end

    it "Should Verify purpose of visit options" do
      expect(@new_request.purpose_of_visit_options).to eq(["Select", "Routine/Follow-Up", "New Issue", "Medication Concern", "Other"])

    end

    it "Should verify office visit preferred type of visit by default when no purpose of visit is selected" do
      expect(@new_request.type_of_visit_radio_elements[0].selected?).to eq(true)
    end

    it "should verify preferred type of visit is phone call for Medication concern and text" do

      @new_request.purpose_of_visit = "Medication Concern"
      expect(@new_request.type_of_visit_radio_elements[1].selected?).to eq(true)
      expect(@new_request.phone_call_warning).to eq("A Phone Call visit is recommended for Medication Concerns.")
    end


    it "Should verify other purpose of visit section max character" do
      @new_request.purpose_of_visit = "Other"
      @new_request.other_purpose_text_element.when_present(TIME_OUT_LIMIT)
      @new_request.other_purpose_text = "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50"
      expect(@new_request.other_purpose_text.length).to eq(50)
    end

    it "Should verify other purpose of visit section max character does not take more than 50 characters" do
      @new_request.other_purpose_text = "MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50" + "abcdefghi"
      @new_request.other_purpose_text_element.fire_event('onblur')

      expect(@new_request.other_purpose_text).to eq("MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50")
      expect(@new_request.other_purpose_text.length).to eq(50)

    end


    it "should verify available options for Type of Visit" do
      expect(@new_request.type_of_visit_radio_values).to eq(["Office Visit", "Phone Call", "Video Conference"])

    end


    it "Should verify instructional text when Video Conference is selected" do
      @new_request.select_type_of_visit_radio("Video Conference")
      expect(@new_request.type_of_visit_radio_elements[2].selected?).to eq(true)
      expect(@new_request.video_conference_warning).to eq("Video Conferences are not available in all VA clinics. If Video Conference appointments are not available, your request will be treated as a Phone Call request.")
    end

    it "Should verify 1st Choice Appointment, am/pm is required" do
      @new_request.clickSubmitRequest
      verifyErrorMessage("Choice #1 Date field is required.")
    end

    it "Verify Choice 1 AM radio is enabled by default" do
      expect(@new_request.am_pm1_elements[0].enabled?).to eq(true)
      expect(@new_request.am_pm1_selected?).to eq("AM")
    end

    it "Should verify option date 1 range error message" do
      @new_request.option_date1 = ""

      #calendar functionality automated in calendar_picker_sepc.rb
      #Value must be between today+5 and today+90;
      threeDaysLater = getDateNthDaysFromNow(3, "%m/%d/%Y")
      @new_request.option_date1 = threeDaysLater
      @new_request.option_date1_element.fire_event('onblur')
      expect(@new_request.option_date1_error).to eq("Please enter a date between " + @fiveDaysLater + " and " + @nintyDaysLater + ".")
    end

    it "Should verify option date 1 range error on submit" do
      @new_request.clickSubmitRequest
      verifyErrorMessage("Please enter a date between " + @fiveDaysLater + " and " + @nintyDaysLater + ".")
    end

    it "Verify date range cannot be more than 90 days" do

      hundredDaysLater = getDateNthDaysFromNow(100, "%m/%d/%Y")
      @new_request.option_date1 = hundredDaysLater
      expect(@new_request.option_date1_error).to eq("Please enter a date between " + @fiveDaysLater + " and " + @nintyDaysLater + ".")
    end

    it "Verify Valid date can be selected" do
      @new_request.option_date1 = getDateNthDaysFromNow(9, "%m/%d/%Y")
      expect(@new_request.option_date1_error).to eq("")
    end

    it "Verify PM radio can be selected" do
      @new_request.select_am_pm1("PM")
      expect(@new_request.am_pm1_selected?).to eq("PM")

    end

    it "Should verify 2st Choice Appointment, am/pm is not enabled as default" do
      expect(@new_request.am_pm2_elements[0].enabled?).to eq(false)

    end

    it "Should Verify @nd choise cannot be before 5 days from now" do
      #calendar functionality automated in calendar_picker_sepc.rb
      #Value must be between today+5 and today+90;
      twoDaysLater = getDateNthDaysFromNow(2, "%m/%d/%Y")
      @new_request.option_date2 = twoDaysLater
      @new_request.option_date2_element.fire_event('onblur')
      @new_request.option_date2_error_element.when_present(TIME_OUT_LIMIT)
      expect(@new_request.option_date2_error).to eq("Please enter a date between " + @fiveDaysLater + " and " + @nintyDaysLater + ".")

    end

    it "Should Verify AM/PM radio of second Choice is not selected by default" do
      expect(@new_request.am_pm2_selected?).to eq(false)

    end

    it "Should Verify error message on submitting a wrong second choice date" do
      @new_request.clickSubmitRequest
      verifyErrorMessage("Please enter a date between " + @fiveDaysLater + " and " + @nintyDaysLater + ".")

    end

    it "Should Verify error message on submitting a second choice date over 90 days" do
      hundredtwentyDaysLater = getDateNthDaysFromNow(120, "%m/%d/%Y")
      @new_request.option_date2 = hundredtwentyDaysLater
      expect(@new_request.option_date2_error).to eq("Please enter a date between " + @fiveDaysLater + " and " + @nintyDaysLater + ".")

    end

    it "Should Verify valid second choice date can be selected" do

      tenDaysLater = getDateNthDaysFromNow(10, "%m/%d/%Y")
      @new_request.option_date2 = tenDaysLater
      expect(@new_request.option_date2_error).to eq("")
    end

    it "Should Verify 2nd choice AM/PM radio is enabled on valid date" do

      expect(@new_request.am_pm2_elements[0].enabled?).to eq(true)
    end

    it "Should Verify default radio selction is AM for second cohice" do
      sleep 1
      expect(@new_request.am_pm2_selected?).to eq("AM")
    end

    it "Should Select PM as second choice" do
      @new_request.select_am_pm2("PM")
      expect(@new_request.am_pm2_selected?).to eq("PM")
    end

    it "Should verify 3st Choice Appointment, am/pm is disabled by default" do
      expect(@new_request.am_pm3_elements[0].enabled?).to eq(false)
    end

    it "should verify default range for third choice" do
      #calendar functionality automated in calendar_picker_sepc.rb
      #Value must be between today+5 and today+90;
      twoDaysLater = getDateNthDaysFromNow(2, "%m/%d/%Y")
      @new_request.option_date3 = twoDaysLater
      expect(@new_request.option_date3_error).to eq("Please enter a date between " + @fiveDaysLater + " and " + @nintyDaysLater + ".")
    end

    it "should verify 3rd choice AM/Pm raido is not selected" do
      expect(@new_request.am_pm3_selected?).to eq(false)
    end

    it "Should verify date range error for wrong 3rd choice date" do
      @new_request.clickSubmitRequest
      verifyErrorMessage("Please enter a date between " + @fiveDaysLater + " and " + @nintyDaysLater + ".")
    end

    it "Should Verify 3rd choice cannot be more than 90 days from now" do

      hundredtwentyDaysLater = getDateNthDaysFromNow(120, "%m/%d/%Y")
      @new_request.option_date3 = hundredtwentyDaysLater
      expect(@new_request.option_date3_error).to eq("Please enter a date between " + @fiveDaysLater + " and " + @nintyDaysLater + ".")
    end

    it "Should Verify valid date can be selected for 3rd choice" do
      eightDaysLater = getDateNthDaysFromNow(8, "%m/%d/%Y")
      @new_request.option_date3 = eightDaysLater
      expect(@new_request.option_date3_error).to eq("")
    end

    it "Should Verify PM can be selected as 3rd Choice" do
      @new_request.select_am_pm3("PM")
      expect(@new_request.am_pm3_selected?).to eq("PM")
    end


    it "Request a phone call & best time to call is visible" do

      expect(@new_request.phoneNumber_element.visible?).to eq(true)
      expect(@new_request.verifyPhoneNumber_element.visible?).to eq(true)
      expect(@new_request.bestTimeToCall_morning_element.visible?).to eq(true)
    end

    it "should verify phone number is required" do
      @new_request.clickSubmitRequest
      verifyErrorMessage("Phone field is required.")
      verifyErrorMessage("Verify Phone field is required.")

    end

    it "should Verify phone number is updated to default format" do
      @new_request.phoneNumber = "7032223333"
      @new_request.phoneNumber_element.fire_event('onblur')
      expect(@new_request.phoneNumber).to eq("(703) 222-3333")
    end

    it "should verify phone number is updated for alphabets" do
      @new_request.phoneNumber = "111Abc1111111"
      @new_request.phoneNumber_element.fire_event('onblur')
      expect(@new_request.phoneNumber).to eq("(111) 111-1111")
    end

    it "should verify a valid phone number check" do
      @new_request.clickSubmitRequest
      verifyErrorMessage("Please enter a valid US Phone number.")
    end

    it "should Verify phone numbers verification" do
      @new_request.phoneNumber = "7032223333"
      @new_request.phoneNumber_element.fire_event('onblur')
      @new_request.verifyPhoneNumber = "1112223333"
      @new_request.verifyPhoneNumber_element.fire_event('onblur')
      @new_request.clickSubmitRequest
      verifyErrorMessage("The phone numbers do not match.")

    end

    it "Verify no error on matching phone numbers" do
      @new_request.verifyPhoneNumber = "7032223333"
      @new_request.verifyPhoneNumber_element.fire_event('onblur')
      expect(@new_request.verify_phone_number_error).to eq("")
    end

    it "Should Verify Best Times for VA to Call field is required" do

      @new_request.clickSubmitRequest
      verifyErrorMessage("Best Times for VA to Call field is required.")

    end

    it "should verify best time to call options can be checked and unchecked" do

      @new_request.check_bestTimeToCall_morning
      @new_request.check_bestTimeToCall_afternoon
      @new_request.check_bestTimeToCall_evening
      @new_request.uncheck_bestTimeToCall_afternoon
      @new_request.uncheck_bestTimeToCall_evening
      expect(@new_request.bestTimeToCall_morning_checked?).to eq(true)
      expect(@new_request.bestTimeToCall_afternoon_checked?).to eq(false)
      expect(@new_request.bestTimeToCall_evening_checked?).to eq(false)
    end

    it "should verify Message a Scheduling Clerk section" do
      expect(@new_request.message_header).to eq("Message a Scheduling Clerk")
      expect(@new_request.new_message_element.attribute("placeholder")).to eq("Messages (100 characters max) should not be used for cancelling an appointment or for clinical questions that may need provider attention.")
      expect(@new_request.message_counter).to eq("100 characters remaining")

    end


    it "should verify character remaining for message a scheduling clerk" do
      @new_request.new_message = @@new_message_50
      expect(@new_request.message_counter).to eq("50 characters remaining")

    end


    it "should verify max character remaining 0 for message a scheduling clerk" do
      @new_request.new_message = @@new_message_50 + @@new_message_50
      expect(@new_request.new_message).to eq(@@new_message_50 + @@new_message_50)
      expect(@new_request.message_counter).to eq("0 characters remaining")

    end

    it "should verify no more than 100 chracters allowed for Message a clerk" do
      @new_request.new_message = @@new_message_50 + @@new_message_50 + "!!@#!@#!@#%^^"
      expect(@new_request.new_message).to eq(@@new_message_50 + @@new_message_50)
      expect(@new_request.message_counter).to eq("0 characters remaining")
    end

    it "should verify default selection for VA to call reagrding this request" do
      expect(@new_request.requestedPhoneCall_selected?).to eq("false")

    end

    it "should verify request a phone call can be slected to Yes" do
      @new_request.requestedPhoneCall_yes_element.click
      expect(@new_request.requestedPhoneCall_selected?).to eq("true")

    end


    it "should verify request a phone call No can be selected" do
      @new_request.requestedPhoneCall_no_element.click
      expect(@new_request.requestedPhoneCall_selected?).to eq("false")

    end

    it "should verify change selection for request a phone call" do
      @new_request.requestedPhoneCall_yes_element.click
      expect(@new_request.requestedPhoneCall_selected?).to eq("true")

    end

    it "should verify Validate Email Preference default selection" do
      expect(@new_request.emailPref_elements[0].selected?).to eq(false)
      expect(@new_request.emailPref_elements[1].selected?).to eq(true)
    end


    it "should verify email pref can be selected to yes" do
      @new_request.select_emailPref("true")
      @new_request.email_element.when_present(TIME_OUT_LIMIT)
      expect(@new_request.emailPref_elements[0].selected?).to eq(true)
      expect(@new_request.emailPref_elements[1].selected?).to eq(false)
      expect(@new_request.email_element.present?).to eq(true)

    end

    it "should verify email field is required" do

      @new_request.schedule_appointment_element.wait_until_present(TIME_OUT_LIMIT)
      button_element = @driver.button(:id => 'schedule-appointment-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
     # @new_request.clickSubmitRequest
      sleep 2
      verifyErrorMessage("Email field is required.")

    end

    it "verify valid email is entered" do

      @new_request.email = "zztest.patient01@test.com"
      @new_request.email_element.fire_event('onblur')
      expect(@new_request.email).to eq("zztest.patient01@test.com")

    end

    xit "should verify unique date selection for all choice dates" do
      puts "TODO: there is an open bug for this. Enable once bug is fixed. Please do not delete"
      sixDaysLater = getDateNthDaysFromNow(6, "%m/%d/%Y")
      @new_request.option_date1 = sixDaysLater
      @new_request.select_am_pm1("PM")
      @new_request.option_date2 = sixDaysLater
      @new_request.select_am_pm2("PM")
      @new_request.option_date3 = sixDaysLater
      @new_request.select_am_pm3("PM")
      @new_request.select_requestedPhoneCall("true")
      @new_request.clickSubmitRequest
      verifyErrorMessage("Choice #1 Date: Date preference must be unique.")
      verifyErrorMessage("Choice #2 Date: Date preference must be unique.")
      verifyErrorMessage("Choice #3 Date: Date preference must be unique.")
    end


    it "should verify form validation when request for phone call is yes" do
      @new_request.select_requestedPhoneCall("false")
      sixDaysLater = getDateNthDaysFromNow(6, "%m/%d/%Y")
      @new_request.option_date1 = sixDaysLater
      @new_request.select_am_pm1("PM")
      @new_request.option_date2 = sixDaysLater
      @new_request.select_am_pm2("PM")
      @new_request.option_date3 = sixDaysLater
      @new_request.select_am_pm3("PM")
      @new_request.clickSubmitRequest
      verifyErrorMessage("Choice #1 Date: Date preference must be unique.")
      verifyErrorMessage("Choice #2 Date: Date preference must be unique.")
      verifyErrorMessage("Choice #3 Date: Date preference must be unique.")
    end


    it "should change option dates to unique" do
      tenDaysLater = getDateNthDaysFromNow(10, "%m/%d/%Y")
      @new_request.option_date2 = tenDaysLater
      @new_request.option_date2_element.fire_event('onblur')
      elevenDaysLater = getDateNthDaysFromNow(11, "%m/%d/%Y")
      @new_request.option_date3 = elevenDaysLater
      @new_request.option_date3_element.fire_event('onblur')
      expect(@new_request.option_date2_error).to eq("")
      expect(@new_request.option_date3_error).to eq("")

    end

    it "should verify request is submitted" do
      @new_request.clickSubmitRequest
      @common.waitWhileSpinnerPresent
      @detail.status_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.has_expected_title?).to eq(true)
    end
  end

  context "AC# VAR-2480|TC # VAR-2517:  New Request -Submission confirmation criteria" do
    it "Should verify request Title: Status, instructional text and date" do
      @detail.status_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.has_expected_title?).to eq(true)

      expect(@detail.status_element.text).to eq("Status: Submitted")
      expect(@detail.status_last_updated_element.text).to include("Updated: " +  @today)

      expect(@detail.status_desc_element.text).to eq("View status updates for this request under the \"Requests\" section of the Appointments and Requests page. Once scheduled, the resulting appointment will be displayed under the “Appointments” section of the same page.")

    end

    it "Should verify Provide Feedback link is displayed on Submission Confirmation page" do
      expect(@detail.provide_feedback_link_element.text).to eq("Provide feedback on this submission.")
    end

    it "Should verify submitted request details" do
      EXPECTED_TEXT = [\
        "Request Details",
        "Submitted: " + @today + " @HH:MM"   " Facility: #{@@locationName} Type of Care: " + PRIMARY_CARE  + " Preferred Type of Visit: " + "Video Conference",
        "Purpose of Visit: Other Other Purpose of Visit: MaxChars50MaxChars50MaxChars50MaxChars50MaxChars50",
        "Preferred Appointment Date/Time",
        "1st Choice: " + getDateNthDaysFromNow(6, "%m/%d/%Y") + " " + "AM" + " 2nd Choice: " + getDateNthDaysFromNow(10, "%m/%d/%Y") + " " + "AM" + " 3rd Choice: " + getDateNthDaysFromNow(11, "%m/%d/%Y") + " " + "AM",
        "Your Contact Information",
        "Email zztest.patient01@test.com Phone (703) 222-3333 Best Times for VA to Call Morning"
      ]
      actual_text = @detail.request_details_group_element.text.split("\n")
      EXPECTED_TEXT.each_with_index do | expectedScreenRow, i |
        if (expectedScreenRow.include?("Submitted:"))
          expect(actual_text[i]).to include("Submitted: " + @today)
          expect(actual_text[i]).to include("Location: #{@@locationName}")
        else
          expect(actual_text[i]).to eq(expectedScreenRow)
        end
      end
    end

    it "should verify messaging a scheduling clerk section" do
      EXPECTED_TEXT = [\
          "Message a Scheduling Clerk",
          "You may send up to two (2) messages while this request is in Submitted status. If you need additional information, please call your local VA Medical Center"
      ]
      actual_text = @detail.communicate_with_clerk_group_element.text.split("\n")
      EXPECTED_TEXT.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i]).to eq(expectedScreenRow)
      end
    end

    it "should verify Email is saved in oracle" do
       sleep 2
       emailId = executeAndGetDataAndNumRow("SELECT EMAIL_ADDRESS FROM VARDB.NOTIFICATION_PREFERENCE WHERE PATIENT_ID = '1113138327'")
       emailArr = emailId.split("||")
       expect(emailArr[0]).to eq("zztest.patient01@test.com")
    end

    it "Should verify location ID is stored in oracle" do
      facilityData = executeAndGetDataAndNumRow("SELECT FACILITY_CODE FROM VARDB.APPOINTMENT_REQUEST WHERE PATIENT_ID = '1113138327' and STATUS ='Submitted'")
      facilityArr = facilityData.split("||")
      facilityArr = facilityArr[0].split(",")
      puts "Data is: ", facilityArr[0]
      expect(facilityArr[0]).to eq(@@locationID)
    end

    it "should verify details on Back button" do
      expect(@detail.back_btn_element.exists?).to eq(true)

      #large form factors
      expect(@detail.back_label).to eq("Appointments/Requests")
      expect(@detail.back_btn_element.visible?).to eq(true)
      expect(@detail.back_btn_element.attribute("aria-label")).to eq("Return to Appointments and Requests")

      #@detail.back_btn

    end

    it "Should click on Provide Feedback link which will take to Feedback form page and verify Feedback form content" do
      @detail.provide_feedback_link
      @feedback.feedbackTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@feedback.feedbackTitle_element.text).to eq("Feedback")
      EXPECTED_TEXT = [\
          "Please take a moment to give us your feedback. Your responses will be anonymous and help us to improve our service to you.",
          "How likely are you to recommend this application to someone else?",
          "How likely are you to recommend this application to someone else? 1 (not at all likely) and 10 (extremely likely)",
          "0 1 2 3 4 5 6 7 8 9 10",
          "Not At All Likely",
          "Extremely Likely",
          "Comments"
      ]
      actual_text= @feedback.feedback_form_element.text.split("\n")
      EXPECTED_TEXT.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i]).to eq(expectedScreenRow)
      end
    end

    it "should verify Feedback page on a smaller form factor" do
      resizeWindowTo(400,800)
      EXPECTED_TEXT = [\
          "Please take a moment to give us your feedback. Your responses will be anonymous and help us to improve our service to you.",
          "How likely are you to recommend this application to someone else?",
          "How likely are you to recommend this application to someone else? 1 (not at all likely) and 10 (extremely likely)",
          "Select",
          "0 - Not at all likely","1","2", "3" ,"4", "5", "6", "7", "8", "9", "10 - Extremely likely",
          "Comments"
      ]
      actual_text= @feedback.feedback_form_element.text.split("\n")
      EXPECTED_TEXT.each_with_index do | expectedScreenRow, i |
        expect(actual_text[i]).to eq(expectedScreenRow)
      end
    end

    it "Select value should disable Submit button" do
      @feedback.selectFeedbackonSmallerform("Select")
      expect(@feedback.feedback_submit_element.enabled?).to eq false
    end

    it "user's selection should enable Submit button" do
      @feedback.selectFeedbackonSmallerform("3")
      expect(@feedback.feedback_submit_element.enabled?).to eq true
    end

    it "user's selection should be retained in default window view" do
      resizeWindowToDefault
      expect(@feedback.feedback_btn_elements[2].attribute("for")).to eq("two")
    end

    it "User should able to provide feedback and submit successfully" do
      @feedback.selectFeedbackondefullform("4")
      @feedback.feedback_comment="This is a Test"
      @feedback.feedback_submit
      @common.waitWhileSpinnerPresent
      expect(@feedback.thanks_msg_element.text).to eq("Thank you! Your feedback has been submitted.")
    end

    it "should verify clicking on back button returns to landing page" do
      button_element = @driver.button(:id => 'back-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @landing_appointments.primary_header_element.when_present(TIME_OUT_LIMIT)
      waitTillRequestsDisplay
      expect(@landing_appointments.getNthRequestTableHeader(1)).to eq("Last Updated")
    end

    it "should verify Request list: Submitted Request added Verify Labels and details" do

      #Column 1 Label: Last Updated
      expect(@landing_appointments.getNthRequestTableHeader(1)).to eq("Last Updated")
      expect(@landing_appointments.getRequestTextForRowCol(1,1)).to eq(@today)

      #Column Label: Status
      expect(@landing_appointments.getNthRequestTableHeader(2)).to eq("Status")
      expect(@landing_appointments.getRequestTextForRowCol(1,2)).to eq("Submitted")

      #Column Label: Location;
      expect(@landing_appointments.getNthRequestTableHeader(3)).to eq("Location")
      expect(@landing_appointments.getRequestTextForRowCol(1,3)).to eq("#{@@locationName}")

      #Column Label: /Type of Care;
      expect(@landing_appointments.getNthRequestTableHeader(4)).to eq("Type of Care")
      expect(@landing_appointments.getRequestTextForRowCol(1,4)).to eq(PRIMARY_CARE)
    end

    it "Should verify Provide Feedback link is not being displayed when Request is accessed from Request Table" do
      @landing_appointments.request_table_list_elements[0].click
      @common.waitWhileSpinnerPresent
      expect(@detail.provide_feedback_link_element.visible?).to eq false
    end

  end
end





